# Début programme de démonstration des entrées analogique (Graphique/2-voie)
# Ce programme mesure et affiche A0 et A1 dans un graphique.

# Le fichier libFenetreGraphiqueTempsReel.py fournit la classe GraphiqueTempsReel.
# GraphiqueTempsReel offre un graphique temps réel a 1 ou deux voies.
# Le fichier libFenetreGraphiqueTempsReel.py doit etre dans le meme répertoire que ce programme.
from libFenetreGraphiqueTempsReel import GraphiqueTempsReel         

# Nous instancions un objet fenetre utilisant la classe "GraphiqueTempsReel".
# Les parametres principaux de la fenetre sont définit par le constructeur.
fenetre = GraphiqueTempsReel(
    nomFenetre="Plug'Uno - acquisition",
    titreFigure="Entrée analogique A0 et A1",
    legendeAxeX="(index échantillon)",
    legendeAxeY="(1/Vcc Plug'Uno)",
    legendeVoie1="A0",
    legendeVoie2="A1", # Active la voie2
    nombrePointSurX=100,
    yMin = 0,
    yMax = 1
)

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)
#plugUno = Arduino(input("Saisir le port de communication COM1, COM2, COM3 .... :"))

################################
# Configuration des E/S
################################
brocheA0 = plugUno.get_pin('a:0:i')
# -> a  : signifie mode analogique
# -> 0  : numéro de la broche (0/1/2/3/4)
# -> i  : mode entré (est seule mode offert part Plug'Uno)
brocheA1 = plugUno.get_pin('a:1:i')

# Active le mécanisme de récuperation des différents états des E/S de Plug'Uno ;
# Définit la fréquence d'échantillonnage.
plugUno.samplingOn( 40 ) # interval de mesure : 40 ms -> 25 Hz

# Définit la fonction qui sera appelé a chaque mesure ADC de A0
valeurA0SAV = 0
def fonctionDeRappelLectureA0(valeurA0):
    global valeurA0SAV
    # Sauvegarde de la valeur de voie A0
    # -> sera utilisé dans la fonction de rappel de A1...
    #...pour mettre a l'écran un couple de valeur A0 + A1
    valeurA0SAV = valeurA0

# Définit la fonction qui sera appelé a chaque mesure ADC de A1
def fonctionDeRappelLectureA1(valeurA1):
    # Méthode d'ajout de donné a la volé de la classe GraphiqueTempsReel
    # La methode attend 2 arguments pour voie1 et voie2
    fenetre.ajouterDonnee(valeurA0SAV,valeurA1)
    

# Indique a l'objet brocheA0 d'appeler la fonction de rappel pour mise a jour ADC.
brocheA0.register_callback(fonctionDeRappelLectureA0)
# Indique a l'objet brocheA1 d'appeler la fonction de rappel pour mise a jour ADC.
brocheA1.register_callback(fonctionDeRappelLectureA1)

# Affiche la fenêtre de tracé de graphique
fenetre.afficher()
# -> méthode dite "blocante".
# Le programme franchira cette instruction quand la fenetre de trace sera fermé.

# Fermer la connection a Plug'Uno avant de quitter.
plugUno.exit()

# Met fin a l'exécution du programme Python.
#exit()

# Fin programme de démonstration des entrées analogique (Graphique/2-voie)
